%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Name: Fuzzy C- Means (FCM)clustering image segmentation algorithm.
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Author: Amit Narahar Pujari, Email contact: amitnpujari@gmail.com
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Run time: Takes approximately 4/5 minutes to completely execute and display the final results (depending on system configuration).
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Software version: Written in MATLAB 6.5 environment.
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Input parameters:
% newimag = gray level image
% V = value of the cluster center
% u = fuzzy value
% clust = number of original clusters
%-------------------------------------------------------------------------------------------------------------------------------------------------------------------
% Output parameters:
% final clustered images, for four clusters
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function [newimag,V,u,nclust] = FCM

%----------------------------------------------------------------------------------------------------------------------------------------------


clear;
newimag = imread('hd03.jpg');                                 % Loads image to be clustered
newimag = rgb2gray(newimag);                                  % Converts RGB colour images in greyscale(for calculations)
newimag = double(newimag);                                    % Converts to double for calculations
[xsize,ysize] = size(newimag);                                % Get image dimensions for looping


cluster = 4;                                                  % Set number of original clusters, 4 clusters: skull, white matter, grey matter, cerebro spinal fluid 

V(1) = 40;                                                    % Initialise Clusters randomly; by assigning the values to the cluster centers 
V(2) = 70;
V(3) = 90;
V(4) = 110;


counter = 0;                                                  %initialise main counter (assign zero value to counter intially to update the counter)
unew = zeros(xsize,ysize,cluster);                            %initialise new fuzzy values

while  counter < 5;                                           %set a limit on the counter
    
    Fh = 0;
    fuzzytotal = 0;
    distsum = 0;
    fuzzysum = zeros(1,cluster);                              % Initialize variables
    csize(1:cluster) = zeros;
    nclust = zeros(xsize,ysize,cluster);
    
    for loop = 1:xsize
        for loop2 = 1:ysize  
            for count = 1:cluster  
                if newimag(loop,loop2) == V(count)                                           %Check for divide by zero
                    dist1 = 1;
                else      
                    dist1 = 1/(abs(newimag(loop,loop2) - V(count)));                         % Dist between vector and cluster centre
                end 
                for newloop = 1:cluster                                                      %Check for divide by zeros again
                    if  newimag(loop,loop2) == V(newloop)
                        distsum =1;
                    else      
                        distsum = distsum + 1/(abs(newimag(loop,loop2) - V(newloop)));       % Dist between vector and all cluster centres summed together
                    end 
                end 
                u(loop,loop2,count) = dist1/distsum;                                         %computes fuzzines for all vectors to each cluster centre 
                distsum = 0;
            end
            distsum = 0; 
            for loop3 = 1:cluster
                fuzzysum(loop3) = fuzzysum(loop3) + u(loop,loop2,loop3)^2;                   %compute the fuzzy membership sum for cluster updating 
            end
            
            
            %-------------------------------------------------------------------------------------------------------------------------------------------------        
            for cloop = 1:cluster                                                            %allocate the pixels by their fuzzy memberships
                if u(loop,loop2,cloop) == max(u(loop,loop2,:)) 
                    nclust(loop,loop2,cloop) = 50;
                    csize(cloop) = csize(cloop) + 1;                                         %cluster size for probability calculation
                end  
            end    
            
        end
    end
    
    temp = zeros(1,cluster);                                                                 %initialize variables
    
    
    
    % -------------- Computes the fuzzy sum multiplied by image pixel values--------------------------------------------------------------------------------
    %------------------- for calculating new cluster centres. ----------------------------------------------------------------------------------------------
    
    for looper1 = 1:cluster                         
        for looper2 = 1:xsize
            for looper3 = 1:ysize
                temp(looper1) = temp(looper1) + (u(looper2,looper3,looper1)^2 * newimag(looper2,looper3));         %Calculate new cluster centres
            end
        end
    end
    
    
    % ------------- Calculates the new centroids for the clusters --------------------------------------------------------------------------------------------
    
    for loop5 = 1:cluster
        V(loop5) = temp(loop5)/fuzzysum(loop5)                                                                     %Update cluster centres
    end 
    
    
    
    
    % -------------- Checkto see if clustering is finished  --------------------------------------------------------------------------------------------------
    
    if abs(unew - u) < 0.01                                                                                        %Check the error criterion
    else
        unew  = u;
    end
    counter = counter+1;
end


% ------------- Displays the final clustered images ----------------------------------------------------------------------------------------------------------

for final = 1:cluster
    figure
    imshow(nclust(:,:,final))                                                                                     %Displays final clustered images
end

